using System;
using System.Collections.Generic;

class Program{
    
    static void Main(){
        int N = int.Parse(Console.ReadLine());
        long[] X = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
        long[] H = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);

        int[] L = new int[N];
        int[] R = new int[N];
        Array.Fill(L, -1);
        Array.Fill(R, -1);

        Stack<int> S = new Stack<int>();

        for (int I = 0; I < N; I++)
        {
            while (S.Count > 0 && H[S.Peek()] <= H[I]) S.Pop();
            if (S.Count > 0) L[I] = S.Peek();
            S.Push(I);
        }

        S.Clear();

        for (int I = N - 1; I >= 0; I--)
        {
            while (S.Count > 0 && H[S.Peek()] <= H[I]) S.Pop();
            if (S.Count > 0) R[I] = S.Peek();
            S.Push(I);
        }

        for (int I = 0; I < N; I++)
        {
            double ANS = double.MaxValue;

            if (L[I] != -1)
                ANS = Math.Min(ANS, DIST(X[I], H[I], X[L[I]], H[L[I]]));

            if (R[I] != -1)
                ANS = Math.Min(ANS, DIST(X[I], H[I], X[R[I]], H[R[I]]));

            if (ANS == double.MaxValue) Console.WriteLine(-1);
            else Console.WriteLine(Math.Round(ANS, 6));
        }
    }

    static double DIST(long X1, long Y1, long X2, long Y2)
    {
        long DX = X1 - X2;
        long DY = Y1 - Y2;
        return Math.Sqrt(DX * DX + DY * DY);
    }
}